
// Selected item in the hinge list
var selectedHinge;
var selectedHingeIndex;
var selectedHole;
var selectedHoleIndex;
var mouseOverItemStyle = "background-color:rgb(193,210,236);";
var selectedItemStyle = "background-color:rgb(79,166,255);";
var hingeLibraryArray = [];

// Receive data from Fusion
window.fusionJavaScriptHandler = {handle: function(action, data){
    try {
        switch (action) {
            case 'send':
                // Update the hinge library array with the data passed in.
                hingeLibraryArray = []
                jsonDatabase = JSON.parse(data);

                var i;
                for (i = 0; i < jsonDatabase.length; i++) {
                    row = jsonDatabase[i];
                    jsonRow = JSON.parse(row);
                    hingeLibraryArray.push(jsonRow);
                }

                createHingeList();
                hingeSelected(hingeList.firstChild);

                break;
            case 'debugger':
                debugger;
                break;
        }
    } catch (e) {
        console.log(e);
        console.log('exception caught with action: ' + action + ', data: ' + data);
        return 'FAILED';
    }
    return 'OK';
}};

function createHingeList(){
    var hingeList = document.getElementById("hingeList");
    while (hingeList.firstChild) {
        hingeList.lastChild.remove();
    }
    var i;
    var filterText = document.getElementById("filter").value;
    for (i = 0; i < hingeLibraryArray.length; i++) {
        // TODO
        if(hingeLibraryArray[i][0].search(filterText) != -1) {
            var listItem = document.createElement('li');
            listItem.addEventListener("mouseover", hingeMouseOver);
            listItem.addEventListener("mouseout", hingeChangeColorToWhite);
            listItem.addEventListener("click", function(){ hingeSelected(this); });
            var listNode = document.createTextNode(hingeLibraryArray[i][0]);
            listItem.appendChild(listNode)
            hingeList.appendChild(listItem);
        }
    }
}

function saveButtonClick(){
    // document.getElementById("p1").innerHTML = hingeLibraryArray;

    var args = {
        library : hingeLibraryArray,
        close : "true"
        // arg2 : "Sample argument 2"
    };
    adsk.fusionSendData('send', JSON.stringify(args));

    document.forms["holeForm"]["previewCheckbox"].checked = false;
}

function closeButtonClick(){
    var args = {
        close : "true"
    };
    adsk.fusionSendData('send', JSON.stringify(args));

    document.forms["holeForm"]["previewCheckbox"].checked = false;
}

// Mouse over the hinge element in the hinge list
function hingeMouseOver(){
    if (this != selectedHinge){
        this.style = mouseOverItemStyle;
    }      
}

// Change the hinge element color to white
function hingeChangeColorToWhite(){
    if (this != selectedHinge){
        this.style = "background-color:white;";
    }
}

// Hinge in the list selected
function hingeSelected(listItem){
    selectedHinge = listItem;

    listItem.style = selectedItemStyle;

    var hingeList = document.getElementById("hingeList");
    var i;
    for (i = 0; i < hingeList.childElementCount; i++) {
        listItem = hingeList.childNodes[i];
        if (listItem != selectedHinge){
            listItem.style = "background-color:white;";
        } 
    }

    var i;
    hingeName = selectedHinge.firstChild.nodeValue;
    for (i = 0; i < hingeLibraryArray.length; i++) {
        row = hingeLibraryArray[i];
        if (row[0] == hingeName){
            // Create hole list
            selectedHingeIndex = i;

            createHoleList();
            holeSelected(holeList.firstChild); 
            break;
        }  
    }
    // previewHinge();
}

function createHoleList(){
    var holeList = document.getElementById("holeList");
    while (holeList.firstChild) {
        holeList.lastChild.remove();
    }

    row = hingeLibraryArray[selectedHingeIndex];
    var i;
    var holeNumber = 0;
    for (i = 1; i < row.length; i = i + 8) {
        if (row[i] != ""){
            holeNumber++;
            var listItem = document.createElement('li');
            listItem.addEventListener("mouseover", holeMouseOver);
            listItem.addEventListener("mouseout", holeChangeColorToWhite);
            listItem.addEventListener("click", function(){ holeSelected(this); });
            var listNode = document.createTextNode(holeNumber);
            listItem.appendChild(listNode)
            holeList.appendChild(listItem);
        }
    }
}

// Mouse over the hole element in the hole list
function holeMouseOver(){
    if (this != selectedHole){
        this.style = mouseOverItemStyle;
    }     
}

// Change the hole element color to white
function holeChangeColorToWhite(){
    if (this != selectedHole){
        this.style = "background-color:white;";
    }
}

function holeSelected(listItem){
    selectedHole = listItem;

    listItem.style = selectedItemStyle;

    var holeList = document.getElementById("holeList");
    var i;
    for (i = 0; i < holeList.childElementCount; i++) {
        listItem = holeList.childNodes[i];
        if (listItem != selectedHole){
            listItem.style = "background-color:white;";
        }  
    }

    var row = hingeLibraryArray[selectedHingeIndex];
    selectedHoleIndex = selectedHole.firstChild.nodeValue - 1;

    document.getElementById("name").value = row[0];
    document.getElementById("x").value = row[selectedHoleIndex * 8 + 1];
    document.getElementById("y").value = row[selectedHoleIndex * 8 + 2];
    document.getElementById("diameter").value = row[selectedHoleIndex * 8 + 3];
    document.getElementById("depth").value = row[selectedHoleIndex * 8 + 4];
    
    var location = row[selectedHoleIndex * 8 + 5];
    switch(location) {
        case "board":
            document.getElementById("board").checked = true;
            break;

        case "boardB":
            document.getElementById("boardB").checked = true;
            break;

        case "faceA":
            document.getElementById("faceA").checked = true;
            break;

        case "faceB":
            document.getElementById("faceB").checked = true;
            break;

        case "":
            document.getElementById("None").checked = true;
            break;
    }
    
    document.getElementById("slotX").value = row[selectedHoleIndex * 8 + 6];
    document.getElementById("slotY").value = row[selectedHoleIndex * 8 + 7];
    document.getElementById("undercut").value = row[selectedHoleIndex * 8 + 8];

    previewHinge();

}

function validateRow(){
    var row = hingeLibraryArray[selectedHingeIndex];

    var numberOfCells = row.length;
    for (i = 1; i < numberOfCells; i = i + 8) {
            var cellValue = row[i];

            if (cellValue != ''){
                var holeNumber = ( ( ( i - 1 ) / 8) + 1 );
                var holeX = row[i];
                // document.getElementById("validationMessageField").innerHTML = typeof holeX;
                if (isNaN(holeX) || holeX == '') {
                    document.getElementById("validationMessageField").innerHTML = 'The x value in the hole ' + holeNumber + ' is invalid.\nx has to be a number delimited by a dot.';
                    return false;
                }

                var holeY = row[i + 1];
                if (isNaN(holeY) || holeY == '') {
                    document.getElementById("validationMessageField").innerHTML = 'The y value in the hole ' + holeNumber + ' is invalid.\ny has to be a number delimited by a dot.';
                    return false;
                }

                var holeDiameter = row[i + 2];
                if (isNaN(holeDiameter) || holeDiameter == '') {
                    document.getElementById("validationMessageField").innerHTML = 'The diameter value in the hole ' + holeNumber + ' is invalid.\nThe diameter has to be a number delimited by a dot.';
                    return false;
                }
                if (holeDiameter <= 0) {
                    document.getElementById("validationMessageField").innerHTML = 'The diameter value in the hole ' + holeNumber + ' is invalid.\nThe diameter has to a positive value.';
                    return false;
                }

                var holeDepth = row[i + 3];
                if (isNaN(holeDepth) || holeDepth == '') {
                    document.getElementById("validationMessageField").innerHTML = 'The depth value in the hole ' + holeNumber + ' is invalid.\nThe depth has to be a number delimited by a dot.';
                    return false;
                }
                if (holeDepth <= 0) {
                    document.getElementById("validationMessageField").innerHTML = 'The depth value in the hole ' + holeNumber + ' is invalid.\nThe depth has to a positive value.';
                    return false;
                }

                var location = row[i + 4];
                if (location == 'facea'){
                    location = 'faceA';
                }
                if (location == 'faceb'){
                    location = 'faceB'
                }
                if (location != '' && location != 'board' && location != 'boardB' && location != 'faceA' && location != 'faceB') {
                    document.getElementById("validationMessageField").innerHTML = 'The location value in the hole ' + holeNumber + ' is invalid.\nThe location has to be empty, "board", "boardB", "faceA", or "faceB".';
                    return false;
                }

                if (row[i + 5] != '' && row[i + 6] != ''){
                    var slotX = row[i + 5]
                    if (isNaN(slotX) || slotX == ''){
                        document.getElementById("validationMessageField").innerHTML = 'The slot x value in the hole ' + holeNumber + ' is invalid.\nSlot x has to be a number delimited by a dot.';
                        return false;
                    }
                    var slotY = row[i + 6]
                    if (isNaN(slotY) || slotY == ''){
                        document.getElementById("validationMessageField").innerHTML = 'The slot y value in the hole ' + holeNumber + ' is invalid.\nSlot y has to be a number delimited by a dot.';
                        return false;
                    }
                    if (slotX == holeX && slotY == holeY){
                        document.getElementById("validationMessageField").innerHTML = 'The slot x and slot y values in the hole ' + holeNumber + ' are invalid.\nSlot x and slot y have to be different from x and y.';
                        return false;
                    }
                }

                var undercut = row[i + 7];
                if (undercut != ''){
                    if (location == 'faceB'){
                        document.getElementById("validationMessageField").innerHTML = 'The undercut value in the hole ' + holeNumber + ' is invalid.\nUndercuts are supported only for the "board", "boardB", and "faceB" locations.';
                        return false;
                    }
                    if (isNaN(undercut)) {
                        document.getElementById("validationMessageField").innerHTML = 'The undercut value in the hole ' + holeNumber + ' is invalid.\nUndercut has to be empty or a number delimited by a dot.';
                        return false;
                    }
                    if (undercut == holeDepth) {
                        document.getElementById("validationMessageField").innerHTML = 'The undercut value in the hole ' + holeNumber + ' is invalid.\nUndercut has to be different than the depth.';
                        return false;
                    }
                }

                document.getElementById("validationMessageField").innerHTML = '';
            }
        }

}

function validateName() {
    var x = document.forms["holeForm"]["name"].value;

    hingeNameArray = [];
    var i;
    for (i = 0; i < hingeLibraryArray.length; i++) {
        if (i != selectedHingeIndex){
            hinge = hingeLibraryArray[i];
            hingeNameArray.push(hinge[0]);
        }
    }

    if (x == "") {
        document.getElementById("validationMessageField").innerHTML = "Name must be filled out.";
        document.forms["holeForm"]["name"].style = "color:red;";
        return false;
    }
    else if (hingeNameArray.includes(x)) {
        document.getElementById("validationMessageField").innerHTML = "Name " + x + " already exists. Name has to be unique.";
        document.forms["holeForm"]["name"].style = "color:red;";
        return false;
    }
    else{
        document.getElementById("validationMessageField").innerHTML = "";
        document.forms["holeForm"]["name"].style = "color:black;";
        hingeLibraryArray[selectedHingeIndex][0] = x;
        selectedHinge.innerHTML = x;
    }
}

function updateHingeLibraryArray(id) {
    var x = document.forms["holeForm"][id].value;

    if (id == "x"){
        hingeLibraryArray[selectedHingeIndex][selectedHoleIndex * 8 + 1] = x;
        return;
    }
    if (id == "y"){
        hingeLibraryArray[selectedHingeIndex][selectedHoleIndex * 8 + 2] = x;
        return;
    }
    if (id == "diameter"){
        hingeLibraryArray[selectedHingeIndex][selectedHoleIndex * 8 + 3] = x;
        return;
    }
    if (id == "depth"){
        hingeLibraryArray[selectedHingeIndex][selectedHoleIndex * 8 + 4] = x;
        return;
    }
    if (id == "slotX"){
        hingeLibraryArray[selectedHingeIndex][selectedHoleIndex * 8 + 6] = x;
        return;
    }
    if (id == "slotY"){
        hingeLibraryArray[selectedHingeIndex][selectedHoleIndex * 8 + 7] = x;
        return;
    } 
    if (id == "undercut"){
        hingeLibraryArray[selectedHingeIndex][selectedHoleIndex * 8 + 8] = x;
        return;
    }
    if (id == "location"){
        hingeLibraryArray[selectedHingeIndex][selectedHoleIndex * 8 + 5] = x;
        return;
    }
}

function addHinge(){
    hingeNameArray = [];
    var i;
    for (i = 0; i < hingeLibraryArray.length; i++) {
        hinge = hingeLibraryArray[i];
        hingeNameArray.push(hinge[0]); 
    }

    newHingeName = 'Hinge ';
    var i = 1;
    newHingeNameWithNumber = newHingeName + i;
    while (hingeNameArray.includes(newHingeNameWithNumber) && i < 100) {
        i ++;
        newHingeNameWithNumber = newHingeName + i;
    }

    newHinge = [newHingeNameWithNumber, "0", "0", "5", "5", "", "", "", ""];
    var numberOfHinges = 20;
    for (i = 2; i < numberOfHinges * 8; i++){
        newHinge.push("");
    }
    hingeLibraryArray.push(newHinge);

    createHingeList();
    var hingeList = document.getElementById("hingeList");
    hingeSelected(hingeList.lastChild);
}

function duplicateHinge(){
    hingeNameArray = [];
    var i;
    for (i = 0; i < hingeLibraryArray.length; i++) {
        hinge = hingeLibraryArray[i];
        hingeNameArray.push(hinge[0]); 
    }

    newHingeName = selectedHinge.innerHTML;
    var i = 1;
    newHingeNameWithNumber = newHingeName + " (" + i + ")";
    while (hingeNameArray.includes(newHingeNameWithNumber) && i < 100) {
        i ++;
        newHingeNameWithNumber = newHingeName + " (" + i + ")";
    }

    newHinge = []
    newHinge[0] = newHingeNameWithNumber;
    for (i = 1; i < hingeLibraryArray[selectedHingeIndex].length; i++) {
        newHinge[i] = hingeLibraryArray[selectedHingeIndex][i];
    }
    
    var numberOfHinges = 20;
    for (i = 2; i < numberOfHinges * 8; i++){
        newHinge.push("");
    }
    hingeLibraryArray.push(newHinge);

    createHingeList();
    var hingeList = document.getElementById("hingeList");
    hingeSelected(hingeList.lastChild);
}

function deleteHinge(){
    hingeLibraryArray.splice(selectedHingeIndex, 1);
    createHingeList();
    if (selectedHingeIndex > 0){
        hingeSelected(hingeList.childNodes[selectedHingeIndex - 1]);
    }
    else {
        hingeSelected(hingeList.firstChild);
    }
}


function addHole(){
    var holeList = document.getElementById("holeList");
    numberOfHoles = holeList.childElementCount
    hingeLibraryArray[selectedHingeIndex].splice(numberOfHoles * 8 + 1, 0, "0", "0", "5", "5", "", "", "", "");
    createHoleList();
    holeSelected(holeList.lastChild);
    // previewHinge();
}

function deleteHole(){
    hingeLibraryArray[selectedHingeIndex].splice(selectedHoleIndex * 8 + 1, 8);
    createHoleList();
    var holeList = document.getElementById("holeList");
    if (selectedHoleIndex > 0){
        holeSelected(holeList.childNodes[selectedHoleIndex - 1]);
    }
    else {
        holeSelected(holeList.firstChild);
    }
    // previewHinge();
}

function previewHinge(){
    validateRow();

    var isPreview = document.forms["holeForm"]["previewCheckbox"].checked;
    // document.getElementById("validationMessageField").innerHTML = isPreview;
    if (isPreview == true){
        var args = {
            preview : "true",
            hinge : hingeLibraryArray[selectedHingeIndex],
            selectedHoleIndex : selectedHoleIndex
        };
        adsk.fusionSendData('send', JSON.stringify(args));
    }
}

function closePreview(){
    var isPreview = document.forms["holeForm"]["previewCheckbox"].checked;
    // document.getElementById("validationMessageField").innerHTML = 'closepreview';
    if (isPreview == false){
        var args = {
            closepreview : "true", 
        };
        adsk.fusionSendData('send', JSON.stringify(args));
    }
}

function delay(callback, ms) {
    var timer = 0;
    return function() {
      var context = this, args = arguments;
      clearTimeout(timer);
      timer = setTimeout(function () {
        callback.apply(context, args);
      }, ms || 0);
    };
}

// Function to delay the preview after the input
$(function(){

    $('#x, #y, #diameter, #depth, #slotX, #slotY, #undercut').on('input',(delay(function (e) {

        previewHinge();

    }, 500)));
});







