# Author - Maciej Rogowski
# Copyright Maciej Rogowski. All rights reserved.
# Description - Creates a multilayer DXF file for milled parts.
#
# Author - Ross Korsky
# Portions of the program were released under the MIT license.
# Copyright (c) 2016 Ross Korsky
# Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
# The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.








































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































import adsk.core



































































































import adsk.fusion



































































































import traceback



































































































import os



































































































import sys



































































































import json



































































































import subprocess



































































































import tempfile



































































































cL62qdlC = None



































































































p169ZFkB = None



































































































P6KQF3wm = None



































































































pWrbJJ3M = "Mill DXF"



































































































FpVzP35N = None



































































































FVF8kWvd = []



































































































kcPDHw12 = False



































































































f1DG2PWg = None



































































































v4s12knj = None



































































































p1wP7Jl7 = []



































































































wq6D3162 = []



































































































def qN9pKtLP(n3n45Dsw):



































































































    if n3n45Dsw:



































































































        n3n45Dsw.messageBox('Failed:\n{}'.format(traceback.format_exc()))



































































































def run(context):



































































































    global cL62qdlC



































































































    global p169ZFkB



































































































    global p1wP7Jl7



































































































    global kcPDHw12



































































































    try:



































































































        cL62qdlC = adsk.core.Application.get()



































































































        p169ZFkB = cL62qdlC.userInterface



































































































        Gc3KVNck = p169ZFkB.commandDefinitions



































































































        bpMvcrV9 = p169ZFkB.commandDefinitions.itemById('MillDXFMRButtonDefIdPython')



































































































        if bpMvcrV9:



































































































            bpMvcrV9.deleteMe()



































































































        CmpSdG4r = p169ZFkB.allToolbarPanels.itemById('SolidScriptsAddinsPanel')



































































































        BGftzK63 = CmpSdG4r.controls.itemById('MillDXFMRButtonDefIdPython')



































































































        if BGftzK63:



































































































            BGftzK63.deleteMe()



































































































        RJ41rCB9 = Gc3KVNck.addButtonDefinition('MillDXFMRButtonDefIdPython',



































































































                                              'Mill DXF',



































































































                                              'Creates a multilayer DXF file for milling.',



































































































                                              './Resources')



































































































        qS9qP3k1 = BPdg8Hbp()



































































































        RJ41rCB9.commandCreated.add(qS9qP3k1)



































































































        p1wP7Jl7.append(qS9qP3k1)



































































































        CmpSdG4r = p169ZFkB.allToolbarPanels.itemById('SolidScriptsAddinsPanel')



































































































        CmpSdG4r.controls.addCommand(RJ41rCB9)



































































































        kcPDHw12 = mqN834w4()



































































































    except Exception:



































































































        qN9pKtLP(p169ZFkB)



































































































def stop(context):



































































































    global p169ZFkB



































































































    global p1wP7Jl7



































































































    global wq6D3162



































































































    try:



































































































        bpMvcrV9 = p169ZFkB.commandDefinitions.itemById('MillDXFMRButtonDefIdPython')



































































































        if bpMvcrV9:



































































































            bpMvcrV9.deleteMe()



































































































        CmpSdG4r = p169ZFkB.allToolbarPanels.itemById('SolidScriptsAddinsPanel')



































































































        BGftzK63 = CmpSdG4r.controls.itemById('MillDXFMRButtonDefIdPython')



































































































        if BGftzK63:



































































































            BGftzK63.deleteMe()



































































































        p1wP7Jl7 = []



































































































        wq6D3162 = []



































































































    except Exception:



































































































        qN9pKtLP(p169ZFkB)



































































































def mqN834w4():



































































































    global p169ZFkB



































































































    try:



































































































        Zr26b2kG = os.path.dirname(os.path.realpath(__file__))



































































































        LqDQ61fh = Zr26b2kG + '/set.set'



































































































        BkNWGgDL = Zr26b2kG + '/options.set'



































































































        if os.path.isfile(LqDQ61fh) and os.path.isfile(BkNWGgDL):



































































































            if os.path.getsize(LqDQ61fh) == 0 or os.path.getsize(BkNWGgDL) == 0:



































































































                return False



































































































            Tr2h46vZ = abs(os.path.getmtime(LqDQ61fh) - os.path.getmtime(BkNWGgDL))



































































































            if Tr2h46vZ >= 2.4 and Tr2h46vZ <= 2.8:



































































































                return True



































































































        return False



































































































    except Exception:



































































































        qN9pKtLP(p169ZFkB)



































































































def wC12Jb16():



































































































    import time



































































































    global p169ZFkB



































































































    try:



































































































        Zr26b2kG = os.path.dirname(os.path.realpath(__file__))



































































































        LqDQ61fh = Zr26b2kG + '/set.set'



































































































        with open(LqDQ61fh, 'w') as R7DB17pB:



































































































            Ls4HjdF8 = 'True'



































































































            R7DB17pB.write(Ls4HjdF8)



































































































        time.sleep(2.5)



































































































        BkNWGgDL = Zr26b2kG + '/options.set'



































































































        with open(BkNWGgDL, 'w') as lbwn3335:



































































































            Ls4HjdF8 = 'True'



































































































            lbwn3335.write(Ls4HjdF8)



































































































    except Exception:



































































































        qN9pKtLP(p169ZFkB)



































































































def QPgBq15H():



































































































    global cL62qdlC



































































































    global p169ZFkB



































































































    try:



































































































        KKvbF526 = cL62qdlC.userName



































































































        BH9jdsPW = KKvbF526



































































































        BJBbF45H = ord(BH9jdsPW[0]) * 5 + ord(BH9jdsPW[1]) * 3 + ord(BH9jdsPW[2]) + ord(BH9jdsPW[3]) + 7482



































































































        dv63gvlJ = "AMP" + str(BJBbF45H)[:4]



































































































        return dv63gvlJ



































































































    except Exception:



































































































        qN9pKtLP(p169ZFkB)



































































































def tcr2H9Mv(g2cPPlpW):



































































































    return chr(int(g2cPPlpW) + 65)



































































































def vQTlJ4cM(T9flJVvR):



































































































    return str(ord(T9flJVvR) - 65)



































































































def CL3tjmwr(Ls4HjdF8):



































































































    if len(Ls4HjdF8) >= 10:



































































































        if Ls4HjdF8[8] == 'K':



































































































            D45BZ5Nl = str((int(vQTlJ4cM(Ls4HjdF8[1])) + int(vQTlJ4cM(Ls4HjdF8[5])) + int(Ls4HjdF8[2]) + int(vQTlJ4cM(Ls4HjdF8[0])) + int(vQTlJ4cM(Ls4HjdF8[4])) + int(Ls4HjdF8[3]) + 7820) * 2)



































































































            if Ls4HjdF8[6] == D45BZ5Nl[-3]:



































































































                if Ls4HjdF8[7] == D45BZ5Nl[-2]:



































































































                    if vQTlJ4cM(Ls4HjdF8[9]) == D45BZ5Nl[-1]:



































































































                        return True



































































































    return False



































































































def SGlFLNcV(qd7LfHBp):



































































































    import pickle



































































































    global p169ZFkB



































































































    try:



































































































        Zr26b2kG = os.path.dirname(os.path.realpath(__file__))



































































































        jBRsdq7q = Zr26b2kG + '/settings.set'



































































































        gm3ttsd7 = open(jBRsdq7q, 'wb')



































































































        pickle.dump(qd7LfHBp, gm3ttsd7)



































































































        gm3ttsd7.close()



































































































    except Exception:



































































































        qN9pKtLP(p169ZFkB)



































































































def GKvgKwgK():



































































































    import pickle



































































































    global p169ZFkB



































































































    try:



































































































        qd7LfHBp = []



































































































        Zr26b2kG = os.path.dirname(os.path.realpath(__file__))



































































































        jBRsdq7q = Zr26b2kG + '/settings.set'



































































































        gm3ttsd7 = open(jBRsdq7q, 'rb')



































































































        if os.path.getsize(jBRsdq7q) > 0:



































































































            qd7LfHBp = pickle.load(gm3ttsd7)



































































































            gm3ttsd7.close()



































































































        return qd7LfHBp



































































































    except Exception:



































































































        qN9pKtLP(p169ZFkB)



































































































def Lkf9C9lP(wS1Cdn33):



































































































    global cL62qdlC



































































































    global p169ZFkB



































































































    global P6KQF3wm



































































































    global pWrbJJ3M



































































































    global FpVzP35N



































































































    global FVF8kWvd



































































































    try:



































































































        m63l6sfw = cL62qdlC.activeProduct



































































































        qzLPt3WM = m63l6sfw.rootComponent



































































































        gm83dVfh = P6KQF3wm



































































































        FVF8kWvd.clear()



































































































        Phw3DNP9 = []



































































































        hSzzCCB7 = adsk.fusion.BRepFace.cast(gm83dVfh.itemById('selectionFace').selection(0).entity)



































































































        QQVLkw7j = gm83dVfh.itemById('holeDia').value



































































































        WgJVgfVj = gm83dVfh.itemById('thickness').value



































































































        K29dp5m6 = gm83dVfh.itemById('separateHoleLayers').value



































































































        JF4r3TKj = gm83dVfh.itemById('section').value



































































































        if P6KQF3wm.itemById('machine').listItems.item(0).isSelected is True:



































































































            b3n7BC9S = 'Homag'



































































































        if P6KQF3wm.itemById('machine').listItems.item(1).isSelected is True:



































































































            b3n7BC9S = 'BiesseRover'



































































































        pWrbJJ3M = hSzzCCB7.body.parentComponent.name



































































































        nb9q224D = qzLPt3WM.sketches



































































































        jm3PcK9l = qzLPt3WM.constructionPlanes.createInput()



































































































        jm3PcK9l.setByOffset(hSzzCCB7, adsk.core.ValueInput.createByReal(- WgJVgfVj / 2))



































































































        CSHbcz2D = qzLPt3WM.constructionPlanes.add(jm3PcK9l)



































































































        FpVzP35N = CSHbcz2D



































































































        PchQ2br5 = nb9q224D.add(CSHbcz2D)



































































































        PchQ2br5.isComputeDeffered = True



































































































        pqm12WN9 = nb9q224D.add(CSHbcz2D)



































































































        pqm12WN9.isComputeDeffered = True



































































































        if not K29dp5m6:



































































































            Ln3pK43Z = nb9q224D.add(CSHbcz2D)



































































































            Ln3pK43Z.isComputeDeffered = True



































































































        else:



































































































            Ln3pK43Z = None



































































































        if JF4r3TKj:



































































































            ck72334j = nb9q224D.add(CSHbcz2D)



































































































            ck72334j.isComputeDeffered = True



































































































        else:



































































































            ck72334j = None



































































































        PchQ2br5.name = 'Perimeter'



































































































        pqm12WN9.name = 'Cutouts'



































































































        if not K29dp5m6:



































































































            Ln3pK43Z.name = 'Drilling'



































































































        if JF4r3TKj:



































































































            ck72334j.name = 'Middle_Section'



































































































        FVF8kWvd.append(PchQ2br5)



































































































        FVF8kWvd.append(pqm12WN9)



































































































        FVF8kWvd.append(Ln3pK43Z)



































































































        FVF8kWvd.append(ck72334j)



































































































        for t51jS3Nq in hSzzCCB7.loops:



































































































            if t51jS3Nq.isOuter:



































































































                for V5jp3z41 in t51jS3Nq.edges:



































































































                    PchQ2br5.project(V5jp3z41)



































































































                    if b3n7BC9S == 'Homag':



































































































                        pqm12WN9.project(V5jp3z41)



































































































            else:



































































































                V5jp3z41 = t51jS3Nq.edges.item(0)



































































































                if V5jp3z41.geometry.curveType == adsk.core.Curve3DTypes.Circle3DCurveType:



































































































                    WBmz2GGF = round(V5jp3z41.geometry.radius * 2, 6)



































































































                    if WBmz2GGF <= QQVLkw7j:



































































































                        if K29dp5m6:



































































































                            if not (WBmz2GGF in Phw3DNP9):



































































































                                mBpF7Q5k = nb9q224D.add(CSHbcz2D)



































































































                                mBpF7Q5k.isComputeDeffered = True



































































































                                mBpF7Q5k.name = "Drilling_" + str(round(WBmz2GGF * 10, 3)) + 'mm'



































































































                                FVF8kWvd.append(mBpF7Q5k)



































































































                                Phw3DNP9.append(WBmz2GGF)



































































































                            else:



































































































                                mBpF7Q5k = qzLPt3WM.sketches.itemByName("Drilling_" + str(round(WBmz2GGF * 10, 3)) + 'mm')



































































































                            mBpF7Q5k.project(V5jp3z41)



































































































                        else:



































































































                            Ln3pK43Z.project(V5jp3z41)



































































































                    else:



































































































                        pqm12WN9.project(V5jp3z41)



































































































                else:



































































































                    for V5jp3z41 in t51jS3Nq.edges:



































































































                        pqm12WN9.project(V5jp3z41)



































































































        if JF4r3TKj:



































































































            m8PKTL36 = []



































































































            r73wQ4kZ = []



































































































            for Q7m7T7jG in hSzzCCB7.body.faces:



































































































                if Q7m7T7jG.geometry.objectType == adsk.core.Cylinder.classType():



































































































                    if not Q7m7T7jG.geometry.axis.isParallelTo(hSzzCCB7.geometry.normal):



































































































                        m8PKTL36.clear()



































































































                        m8PKTL36.append(Q7m7T7jG)



































































































                        r73wQ4kZ = ck72334j.intersectWithSketchPlane(m8PKTL36)



































































































                        if len(r73wQ4kZ) == 2:



































































































                            WF4Gfgw2 = r73wQ4kZ[0]



































































































                            FnLJrQqS = r73wQ4kZ[1]



































































































                            if WF4Gfgw2.startSketchPoint.geometry.distanceTo(FnLJrQqS.startSketchPoint.geometry) < WF4Gfgw2.startSketchPoint.geometry.distanceTo(FnLJrQqS.endSketchPoint.geometry):



































































































                                ck72334j.sketchCurves.sketchLines.addByTwoPoints(WF4Gfgw2.startSketchPoint, FnLJrQqS.startSketchPoint)



































































































                                ck72334j.sketchCurves.sketchLines.addByTwoPoints(WF4Gfgw2.endSketchPoint, FnLJrQqS.endSketchPoint)



































































































                            else:



































































































                                ck72334j.sketchCurves.sketchLines.addByTwoPoints(WF4Gfgw2.startSketchPoint, FnLJrQqS.endSketchPoint)



































































































                                ck72334j.sketchCurves.sketchLines.addByTwoPoints(WF4Gfgw2.endSketchPoint, FnLJrQqS.startSketchPoint)



































































































    except Exception:



































































































        qN9pKtLP(p169ZFkB)



































































































def jbLnKl3f():



































































































    global p169ZFkB



































































































    global pWrbJJ3M



































































































    global FpVzP35N



































































































    global FVF8kWvd



































































































    global P6KQF3wm



































































































    global kcPDHw12



































































































    gm83dVfh = P6KQF3wm



































































































    L5Vs56nF = gm83dVfh.itemById('perimeterTextBox').text



































































































    kWd2cQfK = gm83dVfh.itemById('cutoutsTextBox').text



































































































    b39CfWh4 = gm83dVfh.itemById('drillingTextBox').text



































































































    pdF8hJM1 = "Middle_Section"



































































































    md21c53P = pWrbJJ3M



































































































    if len(FVF8kWvd) != 0:



































































































        adsk.doEvents()



































































































        vh4sVfLW = p169ZFkB.createFileDialog()



































































































        vh4sVfLW.isMultiSelectEnabled = False



































































































        vh4sVfLW.filter = 'DXF files (*.dxf);;All files (*.*)'



































































































        vh4sVfLW.title = 'Save to DXF File'



































































































        vh4sVfLW.initialFilename = '{}.dxf'.format(md21c53P)



































































































        if vh4sVfLW.showSave() == adsk.core.DialogResults.DialogOK:



































































































            Rn5m4H2N = tempfile.TemporaryDirectory()



































































































            FG6VC5Wc = DxfFileMerger()



































































































            qPf1Nk77 = 0



































































































            for wGspwLMV in FVF8kWvd:



































































































                if wGspwLMV is not None:



































































































                    b454dqdh = os.path.join(Rn5m4H2N.name, "sketch" + str(qPf1Nk77) + '.dxf')



































































































                    h96S1fND = wGspwLMV.saveAsDXF(b454dqdh)



































































































                    if h96S1fND:



































































































                        if qPf1Nk77 == 0:



































































































                            FG6VC5Wc.add_file(b454dqdh, L5Vs56nF, 5)



































































































                        if qPf1Nk77 == 1:



































































































                            FG6VC5Wc.add_file(b454dqdh, kWd2cQfK, 1)



































































































                        if qPf1Nk77 == 2:



































































































                            FG6VC5Wc.add_file(b454dqdh, b39CfWh4, 4)



































































































                        if qPf1Nk77 == 3:



































































































                            FG6VC5Wc.add_file(b454dqdh, pdF8hJM1, 3)



































































































                        if qPf1Nk77 >= 4:



































































































                            FG6VC5Wc.add_file(b454dqdh, b39CfWh4 + '_hole_' + wGspwLMV.name[9:], 4)



































































































                qPf1Nk77 = qPf1Nk77 + 1



































































































            try:



































































































                FG6VC5Wc.save(vh4sVfLW.filename)



































































































            except Exception:



































































































                p169ZFkB.messageBox("The file can not be saved. Check if the file is being used by another program.")



































































































            Rn5m4H2N.cleanup()



































































































    for kJS122wN in FVF8kWvd:



































































































        if kJS122wN is not None:



































































































            kJS122wN.deleteMe()



































































































    if FpVzP35N:



































































































        FpVzP35N.deleteMe()



































































































def Vhssm1gV():



































































































    try:



































































































        global p169ZFkB



































































































        global wq6D3162



































































































        if p169ZFkB.palettes.itemById('millDXFMRHelpPalette'):



































































































            p169ZFkB.palettes.itemById('millDXFMRHelpPalette').deleteMe()



































































































            wq6D3162.clear()



































































































        Lm5MVNn6 = p169ZFkB.palettes.add('millDXFMRHelpPalette', 'Mill DXF Help', './resources/Help/Help.html', True, True, True, 450, 460)



































































































        Lm5MVNn6.setPosition(5, 300)



































































































        if len(wq6D3162) == 0:



































































































            mp41sz25 = WGv9M3Pw()



































































































            Lm5MVNn6.incomingFromHTML.add(mp41sz25)



































































































            wq6D3162.append(mp41sz25)



































































































    except Exception:



































































































        qN9pKtLP(p169ZFkB)



































































































class BPdg8Hbp(adsk.core.CommandCreatedEventHandler):



































































































    def __init__(self):



































































































        super().__init__()



































































































    def notify(self, args):



































































































        try:



































































































            global cL62qdlC



































































































            global p169ZFkB



































































































            global P6KQF3wm



































































































            global p1wP7Jl7



































































































            global wq6D3162



































































































            global kcPDHw12



































































































            global v4s12knj



































































































            wq6D3162 = []



































































































            CV8r5rTR = False



































































































            q5fbft8N = mqN834w4()



































































































            if q5fbft8N:



































































































                kcPDHw12 = q5fbft8N



































































































            z6Z9Cnn8 = 'mm'



































































































            qd7LfHBp = GKvgKwgK()



































































































            if qd7LfHBp:



































































































                if len(qd7LfHBp) == 13:



































































































                    CV8r5rTR = True



































































































            sv874cfs = adsk.core.Command.cast(args.command)



































































































            gm83dVfh = sv874cfs.commandInputs



































































































            P6KQF3wm = gm83dVfh



































































































            Lf84pLT1 = gm83dVfh.addSelectionInput('selectionFace', 'Face', 'Select face')



































































































            Lf84pLT1.setSelectionLimits(1, 1)



































































































            Lf84pLT1.addSelectionFilter('PlanarFaces')



































































































            Lf84pLT1.tooltip = 'Select face.'



































































































            sVRVl7mb = gm83dVfh.addDropDownCommandInput('machine', 'Machine', adsk.core.DropDownStyles.TextListDropDownStyle)



































































































            PDmP5Dqt = sVRVl7mb.listItems



































































































            PDmP5Dqt.add('Homag', True, '')



































































































            PDmP5Dqt.add('Biesse Rover', False, '')



































































































            if CV8r5rTR:



































































































                if int(qd7LfHBp[0]) == 0:



































































































                    sVRVl7mb.listItems.item(0).isSelected = True



































































































                if int(qd7LfHBp[0]) == 1:



































































































                    sVRVl7mb.listItems.item(1).isSelected = True



































































































            gm83dVfh.addTextBoxCommandInput('perimeterTextBox', 'Workpiece', '', 1, True)



































































































            CWLSl6tC = gm83dVfh.addValueInput('thickness', 'Panel Thickness', z6Z9Cnn8, adsk.core.ValueInput.createByReal(1.75))



































































































            if CV8r5rTR:



































































































                CWLSl6tC.value = float(qd7LfHBp[1])



































































































            Cr1KMMvm = gm83dVfh.addValueInput('offset', 'Offset', z6Z9Cnn8, adsk.core.ValueInput.createByReal(0.25))



































































































            if CV8r5rTR:



































































































                Cr1KMMvm.value = float(qd7LfHBp[2])



































































































            gm83dVfh.addTextBoxCommandInput('cutoutsTextBox', 'Milling', '', 1, True)



































































































            bC3Wl1zw = gm83dVfh.addValueInput('zDimension', 'Z Dimension', z6Z9Cnn8, adsk.core.ValueInput.createByReal(-0.2))



































































































            if CV8r5rTR:



































































































                bC3Wl1zw.value = float(qd7LfHBp[3])



































































































            J17F5Z3Z = gm83dVfh.addStringValueInput('toolNumber', 'Tool Number', 'T129')



































































































            if CV8r5rTR:



































































































                J17F5Z3Z.value = str(qd7LfHBp[4])



































































































            TPjJMPJ3 = gm83dVfh.addStringValueInput('compensationSide', 'Compensation Side', 'R')



































































































            if CV8r5rTR:



































































































                TPjJMPJ3.value = str(qd7LfHBp[5])



































































































            R68Q5k35 = gm83dVfh.addValueInput('millingDepth', 'Milling Depth', z6Z9Cnn8, adsk.core.ValueInput.createByReal(1.5))



































































































            if CV8r5rTR:



































































































                R68Q5k35.value = float(qd7LfHBp[6])



































































































            VcZrS5m4 = gm83dVfh.addBoolValueInput('fromBottom', 'Depth from the Bottom', True, '', True)



































































































            if CV8r5rTR:



































































































                VcZrS5m4.value = bool(qd7LfHBp[7])



































































































            gm83dVfh.addTextBoxCommandInput('drillingTextBox', 'Drilling', '', 1, True)



































































































            lNs1vj23 = gm83dVfh.addValueInput('holeDia', 'Max Hole Diameter', z6Z9Cnn8, adsk.core.ValueInput.createByReal(1.5))



































































































            lNs1vj23.tooltip = "Max hole diameter for drilling."



































































































            if CV8r5rTR:



































































































                lNs1vj23.value = float(qd7LfHBp[8])



































































































            Z53JmhH9 = gm83dVfh.addValueInput('drillingDepth', 'Drilling Depth', z6Z9Cnn8, adsk.core.ValueInput.createByReal(1.3))



































































































            if CV8r5rTR:



































































































                Z53JmhH9.value = float(qd7LfHBp[9])



































































































            p43j34Z4 = gm83dVfh.addBoolValueInput('separateHoleLayers', 'Separate Hole Layers', True, '', False)



































































































            p43j34Z4.tooltip = "Separate hole layers per diameter."



































































































            if CV8r5rTR:



































































































                p43j34Z4.value = bool(qd7LfHBp[10])



































































































            wG61K1w1 = gm83dVfh.addBoolValueInput('section', 'Include Section', True, '', True)



































































































            wG61K1w1.tooltip = "Include middle section on a separate layer."



































































































            if CV8r5rTR:



































































































                wG61K1w1.value = bool(qd7LfHBp[11])



































































































            R11TgD6j = gm83dVfh.addBoolValueInput('preview', 'Preview', True, '', True)



































































































            if CV8r5rTR:



































































































                R11TgD6j.value = bool(qd7LfHBp[12])



































































































            v4s12knj = gm83dVfh.addBoolValueInput('helpButton', 'Help', False, './resources/Help', False)



































































































            if kcPDHw12 is False:



































































































                gm83dVfh.addTextBoxCommandInput('readonlyTextBox', '', '<div align="left">Trial is limited to preview. You can buy a license at <a href="https://maciejrogowski.com/">maciejrogowski.com</a></div>', 2, True)



































































































                s5BHNSp5 = gm83dVfh.addStringValueInput('key', 'License Key', '')



































































































                s5BHNSp5.tooltip = "Forgot your license key? Contact us at info@maciejrogowski.com. We are here to help you."



































































































            V3JJ6b5n = tgSDS4Cz()



































































































            sv874cfs.validateInputs.add(V3JJ6b5n)



































































































            p1wP7Jl7.append(V3JJ6b5n)



































































































            z3K3V9sv = QB9cqm6r()



































































































            sv874cfs.executePreview.add(z3K3V9sv)



































































































            p1wP7Jl7.append(z3K3V9sv)



































































































            l8P1p8pd = phQ37n32()



































































































            sv874cfs.execute.add(l8P1p8pd)



































































































            p1wP7Jl7.append(l8P1p8pd)



































































































            ZqQQznHM = cHk88dw1()



































































































            sv874cfs.inputChanged.add(ZqQQznHM)



































































































            p1wP7Jl7.append(ZqQQznHM)



































































































            if gm83dVfh.itemById('machine').listItems.item(0).isSelected is True:



































































































                b3n7BC9S = 'Homag'



































































































            if gm83dVfh.itemById('machine').listItems.item(1).isSelected is True:



































































































                b3n7BC9S = 'BiesseRover'



































































































            if b3n7BC9S == 'Homag':



































































































                gm83dVfh.itemById('offset').isEnabled = True



































































































                gm83dVfh.itemById('zDimension').isEnabled = True



































































































                gm83dVfh.itemById('toolNumber').isEnabled = True



































































































                gm83dVfh.itemById('compensationSide').isEnabled = True



































































































                gm83dVfh.itemById('millingDepth').isEnabled = False



































































































                gm83dVfh.itemById('fromBottom').isEnabled = False



































































































            if b3n7BC9S == 'BiesseRover':



































































































                gm83dVfh.itemById('offset').isEnabled = False



































































































                gm83dVfh.itemById('zDimension').isEnabled = False



































































































                gm83dVfh.itemById('toolNumber').isEnabled = False



































































































                gm83dVfh.itemById('compensationSide').isEnabled = False



































































































                gm83dVfh.itemById('millingDepth').isEnabled = True



































































































                gm83dVfh.itemById('fromBottom').isEnabled = True



































































































        except Exception:



































































































            qN9pKtLP(p169ZFkB)



































































































class cHk88dw1(adsk.core.InputChangedEventHandler):



































































































    def __init__(self):



































































































        super().__init__()



































































































    def notify(self, args):



































































































        try:



































































































            gr2bWCKM = adsk.core.InputChangedEventArgs.cast(args)



































































































            gm83dVfh = gr2bWCKM.inputs



































































































            global p169ZFkB



































































































            global kcPDHw12



































































































            global f1DG2PWg



































































































            if gm83dVfh.itemById('machine').listItems.item(0).isSelected is True:



































































































                b3n7BC9S = 'Homag'



































































































            if gm83dVfh.itemById('machine').listItems.item(1).isSelected is True:



































































































                b3n7BC9S = 'BiesseRover'



































































































            WgJVgfVj = gm83dVfh.itemById('thickness').value



































































































            kKrB1mf2 = gm83dVfh.itemById('offset').value



































































































            H598wG25 = gm83dVfh.itemById('zDimension').value



































































































            vmgz9HdB = gm83dVfh.itemById('toolNumber').value



































































































            vD3P563d = gm83dVfh.itemById('millingDepth').value



































































































            Lp9Ntv71 = gm83dVfh.itemById('fromBottom').value



































































































            F1qglsgG = gm83dVfh.itemById('compensationSide').value



































































































            TRwR3mD7 = gm83dVfh.itemById('drillingDepth').value



































































































            if b3n7BC9S == 'Homag':



































































































                L5Vs56nF = "Werkstk_" + str(int(WgJVgfVj * 10)) + '_'



































































































                L5Vs56nF += str(int(((WgJVgfVj * 10) % 1 + 0.00000001) * 10)) + 'Aufmass'



































































































                L5Vs56nF += str(int(kKrB1mf2 * 2 * 10)) + "Versatz" + str(int(kKrB1mf2 * 10)) + '_' + str(int(((kKrB1mf2 * 10) % 1 + 0.00000001) * 10))



































































































                kWd2cQfK = 'V_Fraes_' + str(int(H598wG25 * 10)) + vmgz9HdB + F1qglsgG



































































































                b39CfWh4 = 'V_BohrLS_' + str(int(TRwR3mD7 * 10))



































































































            if b3n7BC9S == 'BiesseRover':



































































































                L5Vs56nF = 'TCHW0B8D' + str(int(WgJVgfVj * 1000))



































































































                kWd2cQfK = 'TCHW0B1D' + str(int(vD3P563d * 1000))



































































































                if Lp9Ntv71:



































































































                    kWd2cQfK = kWd2cQfK + 'PT1'



































































































                b39CfWh4 = 'TCHW0B2D' + str(int(TRwR3mD7 * 1000))



































































































            gm83dVfh.itemById('perimeterTextBox').text = L5Vs56nF



































































































            gm83dVfh.itemById('cutoutsTextBox').text = kWd2cQfK



































































































            gm83dVfh.itemById('drillingTextBox').text = b39CfWh4



































































































            if gr2bWCKM.input.id == 'machine':



































































































                if b3n7BC9S == 'Homag':



































































































                    gm83dVfh.itemById('offset').isEnabled = True



































































































                    gm83dVfh.itemById('zDimension').isEnabled = True



































































































                    gm83dVfh.itemById('toolNumber').isEnabled = True



































































































                    gm83dVfh.itemById('compensationSide').isEnabled = True



































































































                    gm83dVfh.itemById('millingDepth').isEnabled = False



































































































                    gm83dVfh.itemById('fromBottom').isEnabled = False



































































































                if b3n7BC9S == 'BiesseRover':



































































































                    gm83dVfh.itemById('offset').isEnabled = False



































































































                    gm83dVfh.itemById('zDimension').isEnabled = False



































































































                    gm83dVfh.itemById('toolNumber').isEnabled = False



































































































                    gm83dVfh.itemById('compensationSide').isEnabled = False



































































































                    gm83dVfh.itemById('millingDepth').isEnabled = True



































































































                    gm83dVfh.itemById('fromBottom').isEnabled = True



































































































            if gr2bWCKM.input.id == 'helpButton':



































































































                Vhssm1gV()



































































































            if gr2bWCKM.input.id == 'key':



































































































                H6KqqW1G = gm83dVfh.itemById('key').value.upper().strip()



































































































                if CL3tjmwr(H6KqqW1G):



































































































                    gm83dVfh.itemById('readonlyTextBox').text = "License key is valid."



































































































                    wC12Jb16()



































































































                    kcPDHw12 = True



































































































                    gm83dVfh.itemById('key').isVisible = False



































































































                else:



































































































                    if f1DG2PWg is None:



































































































                        f1DG2PWg = QPgBq15H()



































































































                    if H6KqqW1G == f1DG2PWg and f1DG2PWg != '':



































































































                        gm83dVfh.itemById('readonlyTextBox').text = "License key is valid."



































































































                        wC12Jb16()



































































































                        kcPDHw12 = True



































































































                        gm83dVfh.itemById('key').isVisible = False



































































































        except Exception:



































































































            qN9pKtLP(p169ZFkB)



































































































class tgSDS4Cz(adsk.core.ValidateInputsEventHandler):



































































































    def __init__(self):



































































































        super().__init__()



































































































    def notify(self, args):



































































































        global p169ZFkB



































































































        global P6KQF3wm



































































































        try:



































































































            None



































































































        except Exception:



































































































            qN9pKtLP(p169ZFkB)



































































































class QB9cqm6r(adsk.core.CommandEventHandler):



































































































    def __init__(self):



































































































        super().__init__()



































































































    def notify(self, args):



































































































        global p169ZFkB



































































































        global P6KQF3wm



































































































        try:



































































































            gm83dVfh = P6KQF3wm



































































































            if gm83dVfh.itemById('preview').value:



































































































                Lkf9C9lP(True)



































































































        except Exception:



































































































            qN9pKtLP(p169ZFkB)



































































































class phQ37n32(adsk.core.CommandEventHandler):



































































































    def __init__(self):



































































































        super().__init__()



































































































    def notify(self, args):



































































































        global p169ZFkB



































































































        global P6KQF3wm



































































































        global kcPDHw12



































































































        try:



































































































            if kcPDHw12:



































































































                Lkf9C9lP(False)



































































































                jbLnKl3f()



































































































                qd7LfHBp = []



































































































                qd7LfHBp.append(P6KQF3wm.itemById('machine').selectedItem.index)



































































































                qd7LfHBp.append(P6KQF3wm.itemById('thickness').value)



































































































                qd7LfHBp.append(P6KQF3wm.itemById('offset').value)



































































































                qd7LfHBp.append(P6KQF3wm.itemById('zDimension').value)



































































































                qd7LfHBp.append(P6KQF3wm.itemById('toolNumber').value)



































































































                qd7LfHBp.append(P6KQF3wm.itemById('compensationSide').value)



































































































                qd7LfHBp.append(P6KQF3wm.itemById('millingDepth').value)



































































































                qd7LfHBp.append(P6KQF3wm.itemById('fromBottom').value)



































































































                qd7LfHBp.append(P6KQF3wm.itemById('holeDia').value)



































































































                qd7LfHBp.append(P6KQF3wm.itemById('drillingDepth').value)



































































































                qd7LfHBp.append(P6KQF3wm.itemById('separateHoleLayers').value)



































































































                qd7LfHBp.append(P6KQF3wm.itemById('section').value)



































































































                qd7LfHBp.append(P6KQF3wm.itemById('preview').value)



































































































                SGlFLNcV(qd7LfHBp)



































































































            else:



































































































                p169ZFkB.messageBox("Trial is limited to preview.")



































































































        except Exception:



































































































            qN9pKtLP(p169ZFkB)



































































































class WGv9M3Pw(adsk.core.HTMLEventHandler):



































































































    def __init__(self):



































































































        super().__init__()



































































































    def notify(self, args):



































































































        global p169ZFkB



































































































        try:



































































































            sV3bfrlq = adsk.core.HTMLEventArgs.cast(args)



































































































            zVv1w469 = json.loads(sV3bfrlq.data)



































































































            if 'url' in zVv1w469:



































































































                vHRDm54N = zVv1w469['url']



































































































                if sys.platform.startswith('win') or sys.platform.startswith('cygwin'):



































































































                    os.startfile(vHRDm54N)



































































































                elif sys.platform.startswith('darwin'):



































































































                    subprocess.Popen(['open', vHRDm54N])



































































































        except Exception:



































































































            qN9pKtLP(p169ZFkB)



































































































import numbers



































































































def from_hex(value):



































































































    return int(value, 16)



































































































def to_hex(value):



































































































    return format(value, 'X')



































































































class DxfScanner(object):



































































































    def __init__(self, code_lines, start_line_no=0):



































































































        self._code_lines = code_lines



































































































        self._start_line_no = start_line_no



































































































        self._marker = 0



































































































        self._at = 0



































































































        self._limit = len(code_lines)



































































































        self.tag_id = None



































































































        self.value = ''



































































































        assert self._code_lines is not None



































































































    def mark(self):



































































































        self._marker = self._at



































































































    def clear_marker(self):



































































































        self._marker = 0



































































































    def reset(self):



































































































        self._at = 0



































































































        self.clear_marker()



































































































    def backup(self):



































































































        self._at -= 2



































































































        if self._at < 0:



































































































            self._at = 0



































































































    @property



































































































    def dxf_code(self):



































































































        return self._code_lines



































































































    @property



































































































    def line_no(self):



































































































        return self._start_line_no + self._at



































































































    def read(self, expect_tag=None, expect_value=None):



































































































        if self._limit - self._at < 2:



































































































            self.tag_id = None



































































































            self.value = None



































































































            return False



































































































        r = (self._code_lines[self._at], self._code_lines[self._at + 1])



































































































        self._at += 2



































































































        try:



































































































            self.tag_id = int(r[0])



































































































        except ValueError:



































































































            self.tag_id = None



































































































            self.value = None



































































































            return False



































































































        self.value = r[1]



































































































        assert expect_tag is None or self.tag_id == expect_tag, 'Unexpected tag encountered on line ' + str(self.line_no)



































































































        assert expect_value is None or self.value == expect_value, 'Unexpected value encountered on line ' + str(self.line_no)



































































































        return True



































































































    def read_hex(self, expect_tag=None, expect_value=None):



































































































        if expect_value and isinstance(expect_value, numbers.Number):



































































































            expect_value = to_hex(expect_value)



































































































        ret = self.read(expect_tag, expect_value)



































































































        if ret:



































































































            self.value = int(self.value, 16)



































































































        return ret



































































































    def overwrite_current(self, tag_id, value):



































































































        assert self._at >= 2



































































































        self.dxf_code[self._at - 2] = str(tag_id)



































































































        self.dxf_code[self._at - 1] = str(value)



































































































    def slice_from_marker(self):



































































































        return DxfScanner(self._code_lines[self._marker:self._at], self._start_line_no + self._marker)



































































































class DxfVariable(object):



































































































    def __init__(self, name=None, table=None):



































































































        self.name = name



































































































        self._table = table or dict()



































































































    def get(self, tag_id):



































































































        return self._table[tag_id]



































































































    def set(self, tag_id, value):



































































































        self._table[tag_id] = value



































































































    @property



































































































    def value(self):



































































































        TDg3B4Z6 = self._table.keys()



































































































        assert len(TDg3B4Z6) == 1



































































































        return self._table[TDg3B4Z6[0]]



































































































    @value.setter



































































































    def value(self, v):



































































































        TDg3B4Z6 = self._table.keys()



































































































        assert len(TDg3B4Z6) == 1



































































































        self._table[TDg3B4Z6[0]] = v



































































































    @property



































































































    def TPL11Gtj(self):



































































































        return float(self._table['10'])



































































































    @TPL11Gtj.setter



































































































    def TPL11Gtj(self, TPL11Gtj):



































































































        self._table['10'] = TPL11Gtj



































































































    @property



































































































    def lzFT5NFz(self):



































































































        return float(self._table['20'])



































































































    @lzFT5NFz.setter



































































































    def lzFT5NFz(self, lzFT5NFz):



































































































        self._table['20'] = lzFT5NFz



































































































    @property



































































































    def z(self):



































































































        return float(self._table['30'])



































































































    @z.setter



































































































    def z(self, z):



































































































        self._table['30'] = z



































































































class DxfCodeWriter(object):



































































































    def __init__(self, code_lines=None):



































































































        self.code_lines = code_lines if code_lines is not None else []



































































































    def append(self, tag_id, value):



































































































        self.code_lines.append(str(tag_id))



































































































        self.code_lines.append(str(value))



































































































    def append_hex(self, tag_id, value):



































































































        self.code_lines.append(str(tag_id))



































































































        self.code_lines.append(to_hex(value))



































































































    def write_raw(self, code_lines):



































































































        self.code_lines.extend(code_lines)



































































































class DxfSection(object):



































































































    def __init__(self, group_code):



































































































        assert group_code, 'Group Code required for any DXF section instance'



































































































        self.__group_code = group_code



































































































        pass



































































































    @property



































































































    def group_code(self):



































































































        return self.__group_code



































































































    def _write_dxf_code_preamble(self, writer):



































































































        writer.append(0, 'SECTION')



































































































        writer.append(2, self.group_code)



































































































    def _write_dxf_code_postamble(self, writer):



































































































        writer.append(0, 'ENDSEC')



































































































class RawSection(DxfSection):



































































































    def __init__(self, group_code, dxf_code):



































































































        super().__init__(group_code)



































































































        assert dxf_code is not None



































































































        self._dxf_code = dxf_code



































































































    @property



































































































    def dxf_code(self):



































































































        return self._dxf_code



































































































    def write_dxf_code(self, writer):



































































































        self._write_dxf_code_preamble(writer)



































































































        writer.write_raw(self._dxf_code)



































































































        self._write_dxf_code_postamble(writer)



































































































    @staticmethod



































































































    def from_scanner(scanner):



































































































        scanner.read()



































































































        if scanner.tag_id == 0 and scanner.value == 'SECTION':



































































































            scanner.read()



































































































        assert scanner.tag_id == 2



































































































        group_code = scanner.value



































































































        scanner.mark()



































































































        while scanner.read():



































































































            if scanner.tag_id == 0 and scanner.value == 'ENDSEC':



































































































                break



































































































        assert scanner.tag_id == 0 and scanner.value == 'ENDSEC'



































































































        scanner.backup()



































































































        dxf_code = scanner.slice_from_marker().dxf_code



































































































        r = RawSection(group_code, dxf_code)



































































































        scanner.read()



































































































        return r



































































































class DxfTables(DxfSection):



































































































    SECTION_NAME = 'TABLES'



































































































    def __init__(self):



































































































        super().__init__(DxfTables.SECTION_NAME)



































































































        self.__tables = []



































































































        self.__table_lookup = dict()



































































































    def add(self, table):



































































































        self.__tables.append(table)



































































































        self.__table_lookup[table.group_code] = table



































































































    def get_table(self, table_name):



































































































        return self.__table_lookup[table_name]



































































































    def write_dxf_code(self, writer):



































































































        super()._write_dxf_code_preamble(writer)



































































































        for table in self.__tables:



































































































            table.write_dxf_code(writer)



































































































        super()._write_dxf_code_postamble(writer)



































































































    @staticmethod



































































































    def from_scanner(scanner):



































































































        scanner.mark()



































































































        scanner.read()



































































































        if scanner.tag_id == 0 and scanner.value == 'SECTION':



































































































            scanner.read()



































































































            scanner.mark()



































































































        assert scanner.tag_id == 2



































































































        assert scanner.value == DxfTables.SECTION_NAME



































































































        tables = DxfTables()



































































































        while scanner.read():



































































































            if scanner.tag_id == 0 and scanner.value == 'ENDSEC':



































































































                break



































































































            assert scanner.tag_id == 0 and scanner.value == 'TABLE'



































































































            scanner.read()



































































































            assert scanner.tag_id == 2



































































































            scanner.backup()



































































































            if scanner.value == DxfLayers.GROUP_CODE:



































































































                table = DxfLayers.from_scanner(scanner)



































































































            else:



































































































                table = RawTable.from_scanner(scanner)



































































































            tables.add(table)



































































































        assert scanner.tag_id == 0 and scanner.value == 'ENDSEC'



































































































        return tables



































































































class DxfTable(object):



































































































    def __init__(self, group_code, handle):



































































































        assert group_code, 'Group Code required for any DXF Table instance'



































































































        assert handle is not None, 'Handle Required'



































































































        self.__group_code = group_code



































































































        self.__handle = handle



































































































    @property



































































































    def group_code(self):



































































































        return self.__group_code



































































































    @property



































































































    def count(self):



































































































        assert False, 'count not implemented!'



































































































    @property



































































































    def handle(self):



































































































        return self.__handle



































































































    def _write_dxf_code_preamble(self, writer):



































































































        writer.append(0, 'TABLE')



































































































        writer.append(2, self.group_code)



































































































        writer.append_hex(5, self.handle)



































































































        writer.append(100, 'AcDbSymbolTable')



































































































        if self.count > 0:



































































































            writer.append(70, self.count)



































































































    def _write_dxf_code_postamble(self, writer):



































































































        writer.append(0, 'ENDTAB')



































































































class RawTable(DxfTable):



































































































    def __init__(self, group_code, handle, dxf_code, entry_count):



































































































        super().__init__(group_code, handle)



































































































        assert dxf_code is not None



































































































        assert entry_count is not None and entry_count >= 0



































































































        self.__dxf_code = dxf_code



































































































        self.__count = entry_count



































































































    @property



































































































    def count(self):



































































































        return self.__count



































































































    def write_dxf_code(self, writer):



































































































        super()._write_dxf_code_preamble(writer)



































































































        writer.write_raw(self.__dxf_code)



































































































        super()._write_dxf_code_postamble(writer)



































































































    @staticmethod



































































































    def from_scanner(scanner):



































































































        scanner.read()



































































































        if scanner.tag_id == 0 and scanner.value == 'TABLE':



































































































            scanner.read()



































































































        assert scanner.tag_id == 2



































































































        group_code = scanner.value



































































































        scanner.read_hex()



































































































        assert scanner.tag_id == 5 or (group_code == 'DIMSTYLE' and scanner.tag_id == 105)



































































































        handle = scanner.value



































































































        scanner.read(100, 'AcDbSymbolTable')



































































































        scanner.read()



































































































        if scanner.tag_id != 70:



































































































            scanner.backup()



































































































        scanner.mark()



































































































        count = 0



































































































        while scanner.read():



































































































            if scanner.tag_id == 0:



































































































                if scanner.value == 'ENDTAB':



































































































                    break



































































































                if scanner.value == group_code:



































































































                    count += 1



































































































        assert scanner.tag_id == 0 and scanner.value == 'ENDTAB'



































































































        scanner.backup()



































































































        dxf_code = scanner.slice_from_marker().dxf_code



































































































        table = RawTable(group_code, handle, dxf_code, count)



































































































        scanner.read()



































































































        return table



































































































class DxfLayers(DxfTable):



































































































    GROUP_CODE = 'LAYER'



































































































    def __init__(self, handle):



































































































        super().__init__(DxfLayers.GROUP_CODE, handle)



































































































        self.layers = []



































































































    def add(self, layer):



































































































        self.layers.append(layer)



































































































    @property



































































































    def count(self):



































































































        return len(self.layers)



































































































    def write_dxf_code(self, writer):



































































































        super()._write_dxf_code_preamble(writer)



































































































        for layer in self.layers:



































































































            layer.write_dxf_code(writer)



































































































        super()._write_dxf_code_postamble(writer)



































































































    @staticmethod



































































































    def from_scanner(scanner):



































































































        scanner.mark()



































































































        scanner.read()



































































































        if scanner.tag_id == 0 and scanner.value == 'TABLE':



































































































            scanner.read()



































































































            scanner.mark()



































































































        assert scanner.tag_id == 2



































































































        assert scanner.value == DxfLayers.GROUP_CODE



































































































        scanner.read_hex(5)



































































































        handle = scanner.value



































































































        scanner.read(100, 'AcDbSymbolTable')



































































































        scanner.read()



































































































        if scanner.tag_id != 70:



































































































            scanner.backup()



































































































        layers = DxfLayers(handle)



































































































        while scanner.read(0):



































































































            if scanner.value == 'ENDTAB':



































































































                break



































































































            assert scanner.value == DxfLayers.GROUP_CODE



































































































            layers.add(DxfLayer.from_scanner(scanner))



































































































        assert scanner.tag_id == 0 and scanner.value == 'ENDTAB'



































































































        return layers



































































































class DxfLayer(object):



































































































    def __init__(self, name='0', color=0, handle=None, flags=0, linetype='CONTINUOUS'):



































































































        self.name = name.upper()



































































































        self.color = color



































































































        self.handle = handle  



































































































        self.flags = flags    



































































































        self.line_type = linetype  



































































































        pass



































































































    def write_dxf_code(self, writer):



































































































        assert self.handle is not None, 'handle required'



































































































        writer.append(0, 'LAYER')



































































































        writer.append_hex(5, self.handle)



































































































        writer.append(100, 'AcDbSymbolTableRecord')



































































































        writer.append(100, 'AcDbLayerTableRecord')



































































































        writer.append(2, self.name.upper())



































































































        writer.append(70, self.flags)



































































































        if self.color != 0:



































































































            writer.append(62, self.color)



































































































        writer.append(6, self.line_type)



































































































    @staticmethod



































































































    def from_scanner(scanner):



































































































        assert scanner.value == DxfLayers.GROUP_CODE



































































































        scanner.read_hex(5)



































































































        handle = scanner.value



































































































        scanner.read(100, 'AcDbSymbolTableRecord')



































































































        scanner.read(100, 'AcDbLayerTableRecord')



































































































        d = dict()



































































































        while scanner.read():



































































































            if scanner.tag_id == 0:



































































































                scanner.backup()



































































































                break



































































































            d[scanner.tag_id] = scanner.value



































































































        return DxfLayer(d[2], d.get(62, 0), handle, flags=d.get(70, 0), linetype=d.get(6, 'CONTINUOUS'))



































































































class DxfFile(object):



































































































    def __init__(self):



































































































        self.sections = []



































































































        self.section_index = dict()



































































































    def add_section(self, section):



































































































        assert section



































































































        self.sections.append(section)



































































































        self.section_index[section.group_code] = section



































































































    def set_section(self, section):



































































































        assert section



































































































        assert section.group_code in self.section_index



































































































        self.section_index[section.group_code] = section



































































































        for qPf1Nk77, s in enumerate(self.sections):



































































































            if s.group_code == section.group_code:



































































































                self.sections[qPf1Nk77] = section



































































































                break



































































































    def get_section(self, section_name):



































































































        return self.section_index[section_name]



































































































    def write_dxf_code(self, writer=None):



































































































        if not writer:



































































































            writer = DxfCodeWriter()



































































































        for section in self.sections:



































































































            section.write_dxf_code(writer)



































































































        writer.append(0, 'EOF')



































































































        return writer.code_lines



































































































    def read_file(self, filename):



































































































        self.sections = []



































































































        self.section_index = dict()



































































































        with open(filename, 'r') as q84kbN63:



































































































            dxf_code = [readLine.strip() for readLine in q84kbN63.readlines()]



































































































        assert dxf_code, 'Failed to read DXF file.'



































































































        scanner = DxfScanner(dxf_code)



































































































        self.__read_sections(scanner)



































































































    def __read_sections(self, scanner):



































































































        s = scanner



































































































        while s.read() and not (s.tag_id == 0 and s.value == 'EOF'):



































































































            assert s.tag_id == 0 and s.value == 'SECTION', 'Invalid DXF file - expected TAG(0) and SECTION group code.'



































































































            s.read(2)



































































































            section_name = s.value



































































































            s.backup()



































































































            if section_name == DxfTables.SECTION_NAME:



































































































                self.add_section(DxfTables.from_scanner(s))



































































































            else:



































































































                self.add_section(RawSection.from_scanner(s))



































































































class DxfEntitiesMerger(RawSection):



































































































    SECTION_NAME = 'ENTITIES'



































































































    def __init__(self):



































































































        super().__init__(DxfEntitiesMerger.SECTION_NAME, [])



































































































        self.__next_handle = 0x100



































































































        self._writer = DxfCodeWriter(self._dxf_code)



































































































    def merge_from(self, entities_raw_code, set_layer):



































































































        s = DxfScanner(entities_raw_code)



































































































        while s.read():



































































































            if s.tag_id == 5:



































































































                self._writer.append_hex(5, self.__next_handle)



































































































                self.__next_handle += 1



































































































            elif s.tag_id == 8:



































































































                self._writer.append(8, set_layer)



































































































            else:



































































































                self._writer.append(s.tag_id, s.value)



































































































class DxfFileMerger(object):



































































































    def __init__(self):



































































































        self.__file_specs = []



































































































    def add_file(self, filename, layer_name, layer_color):



































































































        assert layer_name



































































































        assert layer_color in range(0, 256)



































































































        self.__file_specs.append((filename, layer_name, layer_color))



































































































    def save(self, filename):



































































































        layers = []



































































































        layers.append(DxfLayer('0', 0, 0x50))



































































































        dxf_file = DxfFile()



































































































        combined_entites = DxfEntitiesMerger()



































































































        for (input_filename, layer_name, layer_color) in self.__file_specs:



































































































            layer = DxfLayer(layer_name, layer_color, len(layers) + 0x50)



































































































            layers.append(layer)



































































































            dxf_file.read_file(input_filename)



































































































            combined_entites.merge_from(dxf_file.section_index[DxfEntitiesMerger.SECTION_NAME].dxf_code, layer.name)



































































































        dxf_file.set_section(combined_entites)



































































































        layers_table = dxf_file.get_section(DxfTables.SECTION_NAME).get_table(DxfLayers.GROUP_CODE)



































































































        layers_table.layers = layers



































































































        dxf_code_lines = dxf_file.write_dxf_code()



































































































        with open(filename, 'w') as q84kbN63:



































































































            for line in dxf_code_lines:



































































































                print(line, file=q84kbN63)



































































































